/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.consumer;

import cn.com.duiba.boot.event.ContextClosingEvent;
import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.params.JobInvokerParams;
import cn.com.duiba.linglong.client.job.consumer.JobConsumerAssert;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.linglong.client.remoteservice.RemoteWorkerStatusService;
import cn.com.duiba.linglong.client.service.channel.JobInvoker;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.web.client.RestTemplate;

public class WorkerJobConsumer
extends AbstractExecutionThreadService {
    private static final Logger log = LoggerFactory.getLogger(WorkerJobConsumer.class);
    @Resource
    private List<JobConsumerAssert> jobConsumerAsserts;
    @Resource
    private WorkerScheduleJobManager workerScheduleJobManager;
    @Resource
    private RemoteWorkerStatusService remoteWorkerStatusService;
    @Resource
    @CanAccessInsideNetwork
    private RestTemplate linglongFetchJobRestTemplate;
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${server.port}")
    private int port;
    private final AtomicBoolean isLink = new AtomicBoolean(false);
    private String workerId;
    private Thread heartbeat;

    @PostConstruct
    public void init() {
        this.workerId = NetUtils.getLocalIp() + ":" + this.port;
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    public void startConsumer() {
        this.startAsync();
        WorkerJobConsumer consumer = this;
        this.heartbeat = new Thread(() -> {
            consumer.awaitRunning();
            while (this.isRunning()) {
                try {
                    this.remoteWorkerStatusService.heartbeat(this.appName, this.workerId);
                    if (this.isLink.compareAndSet(false, true)) {
                        log.info("\u8c03\u5ea6\u5668\u901a\u4fe1\u5efa\u7acb\u5b8c\u6210");
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    log.error("\u5fc3\u8df3\u68c0\u67e5\u5931\u8d25", (Throwable)e);
                    this.isLink.set(false);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        });
        this.heartbeat.setDaemon(true);
        this.heartbeat.setName("linglong.client.heartbeat");
        this.heartbeat.setPriority(10);
        this.heartbeat.start();
    }

    @EventListener(value={ContextClosingEvent.class})
    public void preDestroy() {
        log.info("\u4efb\u52a1\u6d88\u8d39\u8005\u5173\u95ed");
        if (this.isRunning()) {
            this.stopAsync();
            this.awaitTerminated();
        }
        this.heartbeat.interrupt();
        this.remoteWorkerStatusService.stopWorker(this.appName, this.workerId);
    }

    protected void startUp() {
        log.info("Worker job fetch starting.");
    }

    public void run() {
        while (this.isRunning()) {
            try {
                if (!this.canRunJob()) {
                    int retryTime = 3;
                    for (int i = 0; i < retryTime; ++i) {
                        if (!this.isRunning()) {
                            return;
                        }
                        Thread.sleep(1000L);
                    }
                    continue;
                }
                if (!this.isLink.get()) {
                    Thread.sleep(3000L);
                    continue;
                }
                JobInvokerParams params = new JobInvokerParams();
                params.setAppId(this.appName);
                JobInvoker invoker = (JobInvoker)this.linglongFetchJobRestTemplate.postForObject("http://linglong/worker/fetch/requestJobInvoker", (Object)params, JobInvoker.class, new Object[0]);
                if (Objects.isNull(invoker)) continue;
                try {
                    JobKey jobKey = new JobKey("action", invoker.getHistoryId());
                    this.workerScheduleJobManager.submitScheduleJob(jobKey, invoker.getJobLevel());
                }
                catch (Exception e) {
                    log.error("\u4efb\u52a1\u8fd0\u884c\u5931\u8d25", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean canRunJob() {
        for (JobConsumerAssert consumerAssert : this.jobConsumerAsserts) {
            if (consumerAssert.canConsumer()) continue;
            return false;
        }
        return true;
    }
}

