/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.jobs;

import cn.com.duiba.linglong.client.job.WorkerScheduleProperties;
import cn.com.duiba.linglong.client.job.jobs.AbstractJob;
import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class WorkerJobBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(WorkerJobBeanFactoryPostProcessor.class);
    private Map<String, Class<? extends AbstractJob>> jobInfos;

    public void postProcessBeanDefinitionRegistry(@NotNull BeanDefinitionRegistry registry) throws BeansException {
        for (Map.Entry<String, Class<? extends AbstractJob>> entry : this.jobInfos.entrySet()) {
            String jobType = entry.getKey();
            Class<? extends AbstractJob> jobClass = entry.getValue();
            log.info("\u52a0\u8f7d\u4efb\u52a1\u7c7b\u578b:{},Class:{}", (Object)entry.getKey(), (Object)entry.getValue().getName());
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(jobClass);
            beanDefinition.setScope("prototype");
            beanDefinition.setAutowireCandidate(true);
            registry.registerBeanDefinition("$$LinglongJob:" + jobType, (BeanDefinition)beanDefinition);
        }
    }

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(@NotNull Environment environment) {
        PropertyResolver resolver = new PropertyResolver(environment, "linglong.sdk.schedule");
        WorkerScheduleProperties workerScheduleProperties = (WorkerScheduleProperties)resolver.bindToConfig(WorkerScheduleProperties.class);
        this.jobInfos = workerScheduleProperties.getJobs();
    }
}

