/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job.render;

import cn.com.duiba.linglong.client.job.jobs.JobContext;
import cn.com.duiba.linglong.client.job.render.DateTool;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRender {
    private static final Logger log = LoggerFactory.getLogger(ConfigRender.class);
    private static final String INSTANTIATING = "$$INSTANTIATING";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    public static final Set<String> TIME_KEY_PREFIX = ImmutableSet.of((Object)"now", (Object)"zdt");
    @Resource
    private VelocityEngine velocityEngine;
    private final Map<String, String> cache = Maps.newHashMap();
    private final Stack<String> stack = new Stack();
    private Properties repository;
    private final VelocityContext velocityContext = new VelocityContext();

    public String getRenderConfig(String key) {
        if (this.cache.containsKey(key)) {
            if (StringUtils.equals((String)this.cache.get(key), (String)INSTANTIATING)) {
                ArrayList circularKeys = Lists.newArrayList(this.stack);
                circularKeys.add(key);
                Joiner joiner = Joiner.on((String)"->").skipNulls();
                throw new RuntimeException("\u914d\u7f6e\u5faa\u73af\u4f9d\u8d56:" + joiner.join((Iterable)circularKeys));
            }
            return this.cache.get(key);
        }
        try {
            this.stack.push(key);
            this.cache.put(key, INSTANTIATING);
            String sourceValue = this.getRepositoryValue(key);
            Set<String> dependencies = ConfigRender.analyseScript(sourceValue);
            Properties dependencieKeyValues = new Properties();
            for (String preKey : dependencies) {
                dependencieKeyValues.put(preKey, this.getRenderConfig(preKey));
            }
            String renderValue = ConfigRender.replaceArgs(sourceValue, dependencieKeyValues);
            this.cache.put(key, renderValue);
            String string = this.cache.get(key);
            return string;
        }
        catch (Exception e) {
            if (Objects.equals(this.cache.get(key), INSTANTIATING)) {
                this.cache.remove(key);
            }
            throw e;
        }
        finally {
            this.stack.pop();
        }
    }

    private String getRepositoryValue(String key) {
        if (this.isDateToolKey(key)) {
            StringWriter writer = new StringWriter();
            String inString = "$!{" + key + "}";
            try {
                this.velocityEngine.evaluate((Context)this.velocityContext, (Writer)writer, "", inString);
            }
            catch (Exception e) {
                log.debug("\u914d\u7f6e\u6e32\u67d3\u5931\u8d25", (Throwable)e);
            }
            return writer.toString();
        }
        return this.repository.getProperty(key, "");
    }

    private boolean isDateToolKey(String key) {
        for (String item : TIME_KEY_PREFIX) {
            if (!StringUtils.equals((String)key, (String)item) && !StringUtils.startsWith((String)key, (String)(item + "."))) continue;
            return true;
        }
        return false;
    }

    public void setRepository(JobContext jobContext) {
        this.repository = jobContext;
        Objects.requireNonNull(jobContext.getTime());
        DateTool dateTool = new DateTool(jobContext.getTime());
        for (String key : TIME_KEY_PREFIX) {
            this.velocityContext.put(key, (Object)dateTool);
        }
    }

    public static Set<String> analyseScript(String script) {
        if (StringUtils.isBlank((String)script)) {
            return Collections.emptySet();
        }
        HashSet keys = Sets.newHashSet();
        Matcher matcher = PATTERN.matcher(script);
        while (matcher.find()) {
            keys.add(matcher.group(1));
        }
        return keys;
    }

    public static String replaceArgs(String template, Properties data) {
        if (StringUtils.isBlank((String)template)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            Matcher matcher = PATTERN.matcher(template);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = "";
                if (data.containsKey(name)) {
                    value = data.getProperty(name, "");
                }
                if (!StringUtils.isNotBlank((String)value)) continue;
                value = value.replaceAll("\\\\", "\\\\\\\\");
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
        }
        catch (Exception e) {
            log.error("\u6e32\u67d3\u5931\u8d25", (Throwable)e);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String sss = "dsds:${@now}:dsdsds";
        Properties properties = new Properties();
        System.out.println(ConfigRender.replaceArgs(sss, properties));
    }
}

