package cn.com.duiba.linglong.sdk;

import cn.com.duiba.linglong.sdk.cluster.ClusterConfiguration;
import cn.com.duiba.linglong.sdk.job.WorkerScheduleConfiguration;
import cn.com.duiba.linglong.sdk.monitor.WorkerMonitorConfiguration;
import cn.com.duiba.linglong.sdk.service.JobStatusManager;
import cn.com.duiba.linglong.sdk.service.channel.JobConsumerChannel;
import cn.com.duiba.linglong.sdk.service.channel.JobConsumerChannelManager;
import cn.com.duiba.linglong.sdk.service.logger.JobLogConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

/**
 * @author liuyao
 */
@Configuration
@Import({
        ClusterConfiguration.class,
        JobLogConfiguration.class,
        WorkerMonitorConfiguration.class,
        WorkerScheduleConfiguration.class
})
public class WorkerSdkConfiguration {

    @Bean
    public JobStatusManager jobStatusManager(){
        return new JobStatusManager();
    }

    @Bean
    public JobConsumerChannelManager jobConsumerChannelManager(){
        return new JobConsumerChannelManager();
    }

    @Bean
    @Scope("prototype")
    public JobConsumerChannel jobConsumerChannel(){
        return new JobConsumerChannel();
    }

}
