package cn.com.duiba.linglong.sdk.cluster.hazelcast;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ZookeeperDiscoveryStrategyFactory implements DiscoveryStrategyFactory {

    @Resource
    private ZookeeperDiscoveryStrategy zookeeperDiscoveryStrategy;

    @Override
    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return ZookeeperDiscoveryStrategy.class;
    }

    @Override
    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        zookeeperDiscoveryStrategy.setDiscoveryNode(discoveryNode);
        return zookeeperDiscoveryStrategy;
    }

    @Override
    public Collection<PropertyDefinition> getConfigurationProperties() {
        return Collections.emptyList();
    }
}
