package cn.com.duiba.linglong.sdk.cluster.zookeeper;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liuyao
 */
@Data
@ConfigurationProperties(prefix = "linglong.zookeeper")
public class ZookeeperProperties {

    /**
     * canal在zookeeper中的 namespace
     */
    private String namespace = "linglong";
    /**
     * canal在zookeeper中的 rootPath
     */
    private String rootPath = "/linglong/root-node";
    /**
     * zookeeper集群地址
     */
    private String hosts = "127.0.0.1:2101";
    /**
     * 重新连接时，初次连接的停顿时间
     */
    private Integer baseSleepTime = 1000;
    /**
     * 最大连接次数
     */
    private Integer maxRetries = 3;



}
