package cn.com.duiba.linglong.sdk.domain.dto;

import cn.com.duiba.linglong.sdk.constant.JobInvokeType;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author liuyao
 */
@Data
public class JobKey implements Serializable {

    private static final long serialVersionUID = 6625135822527091030L;

    /**
     * @see JobInvokeType
     */
    private String invokeType;

    private Long historyId;

    public JobKey(){}

    public JobKey(String invokeType,Long historyId){
        this.invokeType = invokeType;
        this.historyId = historyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobKey)) {
            return false;
        }
        JobKey jobKey = (JobKey) o;
        return invokeType.equals(jobKey.invokeType) &&
                historyId.equals(jobKey.historyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(invokeType, historyId);
    }

    public String key() {
        return invokeType+":"+historyId;
    }
}
