package cn.com.duiba.linglong.sdk.monitor;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author liuyao
 */
@Configuration
@EnableConfigurationProperties(MonitorProperties.class)
@ConditionalOnProperty(name="linglong.sdk.monitor.enable", havingValue="true")
public class WorkerMonitorConfiguration {

    /**
     * 对cpu使用量进行监控
     */
    @Bean
    public CpuInfoService cpuInfoService(){
        return new CpuInfoService();
    }

    @Bean
    public MemUseRateInfoService memUseRateInfoService(){
        return new MemUseRateInfoService();
    }

}
