package cn.com.duiba.linglong.sdk.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.linglong.sdk.constant.JobStatus;
import cn.com.duiba.linglong.sdk.domain.dto.JobInvokerInfoDto;
import cn.com.duiba.linglong.sdk.domain.dto.JobKey;
import cn.com.duiba.linglong.sdk.domain.params.JobCallback;
import cn.com.duiba.linglong.sdk.domain.params.JobRunningCallback;
import cn.com.duiba.linglong.sdk.domain.params.JobScriptParams;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteActionCallbackService {

    /**
     * 拉取任务脚本
     * @param id 任务id
     * @return 任务脚本信息
     */
    JobInvokerInfoDto findJobInvokerInfo(Long id) throws BizException;
    /**
     * 修改任务脚本
     * @param params
     * @throws BizException
     */
    void updateJobScript(JobScriptParams params) throws BizException;

    /**
     * 开始调度回调
     */
    JobInvokerInfoDto runningAck(JobRunningCallback callback) throws BizException;

    /**
     * 任务执行结果回调
     * @param callback 回调结果
     */
    void jobCallback(JobCallback callback) throws BizException;

}
