package cn.com.duiba.linglong.sdk.service.channel;

import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.core.HazelcastInstance;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
@Slf4j
public class JobConsumerChannel{

    @Resource
    private HazelcastInstance linglongHazelcastClient;

    private IQueue<Long> high;
    private IQueue<Long> middle;
    private IQueue<Long> lower;
    private ISet<Long> jobKeySet;

    public void init(String appName){
        this.high = linglongHazelcastClient.getQueue("JobConsumerChannel.high:"+appName);
        this.middle = linglongHazelcastClient.getQueue("JobConsumerChannel.middle:"+appName);
        this.lower = linglongHazelcastClient.getQueue("JobConsumerChannel.lower:"+appName);
        this.jobKeySet = linglongHazelcastClient.getSet("JobConsumerChannel.jobKeySet");
    }

    public Long takeJob() {
        Long historyId = take();
        if(Objects.isNull(historyId)){
            return null;
        }
        if(jobKeySet.remove(historyId)){
            return historyId;
        }
        return null;
    }

    private Long take(){
        try{
            Long historyId = high.poll();
            if(Objects.nonNull(historyId)){
                return historyId;
            }
            historyId = middle.poll();
            if(Objects.nonNull(historyId)){
                return historyId;
            }
            return lower.poll(2, TimeUnit.SECONDS);
        }catch (InterruptedException e){
            log.error("消费任务失败",e);
            return null;
        }
    }

    void pushJobKey(JobLevel jobLevel,Long historyId){
        if(jobKeySet.contains(historyId)){
            return;
        }
        try{
            jobKeySet.add(historyId);
            switch (jobLevel){
                case HIGH:high.add(historyId);break;
                case LOWER:lower.add(historyId);break;
                case MIDDLE:
                default:middle.add(historyId);
            }
        }catch (Exception e){
            log.error("发布失败",e);
            jobKeySet.remove(historyId);
        }
    }

    void removeJobKey(Long historyId){
        jobKeySet.remove(historyId);
    }

}
