package cn.com.duiba.linglong.sdk.service.channel;

/**
 * @author liuyao
 */
public enum JobLevel {
    /**
     * 高等级
     */
    HIGH(3),
    /**
     * 中等级
     */
    MIDDLE(2),
    /**
     * 低等级
     */
    LOWER(1);

    private final Integer priority;

    JobLevel(Integer priority){
        this.priority = priority;
    }

    public Integer getPriority() {
        return priority;
    }

    public static JobLevel parse(Integer priority){
        switch (priority){
            case 1:return LOWER;
            case 2:return MIDDLE;
            case 3:return HIGH;
            default:return MIDDLE;
        }
    }

}
