package cn.com.duiba.linglong.sdk.utils;

import lombok.extern.slf4j.Slf4j;

import java.io.Closeable;
import java.io.IOException;

@Slf4j
public final class IOUtils {

    private IOUtils() {
    }

    /**
     * Close safely.
     *
     * @param closeable the closeable
     */
    public static void closeSafely(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (IOException e) {
                log.debug("Error while closing " + closeable, e);
            }
        }
    }
}
