package cn.com.duiba.live.clue.center.api.dto.order;

import cn.com.duiba.live.clue.center.api.constant.LiveUserKillGoodsHashKeyConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户秒杀数据  redis 缓存 1天
 *
 * @author xuzhigang
 * @date 2021/8/13 5:58 下午
 **/
@Data
public class LiveUserKillGoodsRedisDto implements Serializable {
    private static final long serialVersionUID = -8431505221034657067L;


    /**
     * 订单数据
     * @see LiveUserKillGoodsOrderDto
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.ORDER_DATA)
    private String orderData;

    /**
     * 订单id
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.ORDER_ID)
    private String orderId;

    /**
     * 止付时间
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.EXPIRE_TIME)
    private Date expireTime;

    /**
     * 预付单号
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.PRE_PAY_ORDER_ID)
    private String prePayOrderId;

    /**
     * 已支付次数
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.HAS_PAID_TIMES)
    private Integer hasPaidTimes;
}
