package cn.com.duiba.live.clue.center.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户下单临时结果
 * LC186 redis对象
 *
 * @author xuzhigang
 * @date 2021/8/15 5:28 下午
 **/
@Data
public class LiveUserKillGoodsTempRedisDto implements Serializable {
    private static final long serialVersionUID = 7466834069804607623L;

    /**
     * 下单成功/失败 true:成功 ,false:失败
     */
    private boolean success;

    /**
     * 失败错误码
     * @see cn.com.duiba.live.clue.center.api.enums.order.SecKillFailCodeEnum
     */
    private Integer failCode;

    /**
     * 下单 失败原因
     */
    private String failReason;

    /**
     * 预支付单号
     */
    private String prePayOrderId;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 止付时间
     */
    private Date expireTime;

    /**
     * 支付时间
     */
    private Date paidTime;

}
