package cn.com.duiba.live.clue.center.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 直播红包-红包流程各个节点
 * 业务方慎用！！！
 * @author dugq
 * @date 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteLiveRedEventService {

    /**
     * 开始收集用户信息
     * @param liveId 直播ID
     */
    void startCollect(Long liveId);

    /**
     * 异步收集在线有助力的用户
     * @param liveId 直播ID
     * @param confId 配置ID
     */
    void asyncCollectLuck(Long liveId, Long confId);

    /**
     * 计算哪些人中红包
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void compute(Long liveId, Long confId);

    /**
     * 停止领取
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void stopReceive(Long liveId, Long confId);

    /**
     * 补充马甲
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void addVestAndEnd(Long liveId, Long confId);

    /**
     * 直播答题红包 金额预分配
     * @param liveId 直播ID
     * @param confId 红包ID
     */
    void redPreDistribution(Long liveId,Long confId);

    /**
     * 直播红包 金额预分配
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 是否成功
     */
    boolean redPreDistributionNew(Long liveId,Long confId);
}
