package cn.com.duiba.live.clue.center.api.dto.treasure.participate;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播宝箱用户参与信息详情
 * @author 吴文哲
 * @date 2021/4/9 2:51 下午
 **/
@Data
public class LiveTreasureUserParticipateInfoDto implements Serializable {

    private static final long serialVersionUID = -7576859210397323819L;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 奖品领取状态
     * @see cn.com.duiba.live.clue.center.api.enums.treasure.LiveTreasureReceiveStateEnum
     */
    private Integer receiveStatus;

    /**
     * 错误原因
     * @see cn.com.duiba.live.clue.center.enums.TreasureFailCodeEnum
     */
    private Integer failCode;

    /**
     * 宝箱类型
     * @see cn.com.duiba.live.conf.service.api.enums.treasure.TreasureTypeEnums
     */
    private Integer treasureType;

    /**
     * 宝箱关联id
     */
    private Long treasureRelatedId;

    /**
     * 中奖时间
     */
    private Date awardTime;

    /**
     * 是否是降级
     */
    private boolean degree;

    /**
     * 实物奖品
     */
    private LiveTreasureReceiveAwardDto award;

    /**
     * 抽奖码
     */
    private LiveTreasureReceiveCodeDto code;

    /**
     * 红包
     */
    private LiveTreasureReceiveRedDto red;

    /**
     * 开启次数
     */
    private Integer openTimes;
}
