package cn.com.duiba.live.clue.center.api.dto.agent.invite.reward;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhuenhui
 * @date 2021/09/03 15:27
 * @description 代理人邀约红包 - 用户记录
 */
@Data
public class AgentInviteRewardUserRecordDto implements Serializable {

    private static final long serialVersionUID = -1084058730816278329L;

    /**
     * 邀请人数
     */
    private Integer inviteNum;

    /**
     * 开红包状态，未领取，领取中，开始发钱，领取失败，发钱成功，发钱失败
     *
     * @see cn.com.duiba.live.clue.center.api.enums.red.LiveRedPacketReceiveStateEnum
     */
    private Integer redStatus;

    /**
     * 金额
     */
    private Integer redAmount;

    /**
     * 错误码
     * {@link cn.com.duiba.live.clue.center.api.enums.agent.invite.reward.AgentInviteRewardFailCodeEnum}
     */
    private Integer failCode;

}
