package cn.com.duiba.live.clue.center.api.enums.agent.invite.reward;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2021/09/03 14:45
 * @description 代理人邀约奖励 - 错误码枚举
 */
@Getter
@AllArgsConstructor
public enum AgentInviteRewardFailCodeEnum {

    CONF_NOT_FOUND(1, "代理人邀约奖励配置未找到"),
    TIME_NOT_ARRIVED(2, "未到红包发放时间"),
    RECORD_NOT_FIND(3, "用户记录未找到"),
    FILTER_COMMON_FAIL(4, "红包通用过滤失败"),
    RED_STOCK_NOT_ENOUGH(5, "红包库存不足"),
    NOT_AGENT(6, "不是代理人"),

    NOT_MATCH_CONDITION(7, "用户状态 - 不满足开红包条件"),
    ALREADY_OPEN(8, "用户状态 - 已经开启过红包"),

    CENTER_COMPANY_FAIL(200014, "企业付款到零钱结果失败"),
    CENTER_COMPANY_RECEIVING(200015, "企业付款到零钱结果领取中"),
    CENTER_COMPANY_ACCOUNT_SIMPLE_BAN(200016, "用户未实名认证"),
    ;

    private final Integer code;
    private final String desc;
}
