package cn.com.duiba.live.clue.center.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 秒杀失败错误码
 * @author 吴文哲
 * @date 2021/4/20 6:56 下午
 **/
@Getter
@AllArgsConstructor
public enum SecKillFailCodeEnum {

    AGENT_CAN_NOT_PARTICIPATE(1,"代理人无法参与"),
    NOT_MATCH_SEC_KILL_CONDITION(2,"不符合秒杀参与条件"),
    HAS_AL_READY_PURCHASE(3,"已经支付成功了"),
    GENERATE_PRE_PAY_ORDER(4,"预支付单号生成中"),
    LOCAL_STOCK_NOT_ENOUGH(5,"本地库存不足"),
    OPEN_ID_INFO_ERROR(6,"openId信息异常"),
    REDIS_STOCK_NOT_ENOUGH(7,"实际库存不足"),
    DECR_STOCK_FAILURE(8,"扣减库存不足"),
    GOODS_AMOUNT_ERROR(9,"商品金额非法"),
    ORDER_INFO_NOT_EXISTS(10,"下单信息不存在"),
    ORDER_SUCCESS(11,"下单成功"),
    OA_FILTER_ERROR(12,"oa过滤异常"),
    CONF_NOT_FIND(13,"配置不存在"),
    AGENT_PAY_SUCCESS_COUNT_TOO_MORE(14, "代理人名下秒杀成功次数过多"),
    SEC_KILL_LIMIT_GROUP(15, "秒杀限制"),


    ;

    /**
     * 错误码
     */
    private final  Integer code;

    /**
     * 描述
     */
    private final String desc;
}
