package cn.com.duiba.live.clue.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.LiveLotteryCompanySpecifyDto;
import cn.com.duiba.live.clue.service.api.dto.conf.LotteryCompanySpecifySimpleDto;
import cn.com.duiba.live.clue.service.api.param.conf.LiveLotteryCompanySpecifySearchParam;

import java.util.List;
import java.util.Map;

/**
 * 企业指定中奖
 * @author lizhi
 * @date 2020/11/23 1:35 下午
 */
@AdvancedFeignClient
public interface RemoteLiveLotteryCompanySpecifyApiService {

    /**
     * 批量新增
     * @param list 直播配置-企业指定中奖集合
     * @return 执行结果
     */
    int batchInsert(List<LiveLotteryCompanySpecifyDto> list);

    /**
     * 批量逻辑删除
     * @param idList 之间集合
     * @return 执行结果
     */
    int batchDelete(List<Long> idList);

    /**
     * 分页查询手机号
     * @param param 分页查询参数
     * @return 手机号集合
     */
    List<Long> selectIdPage(LiveLotteryCompanySpecifySearchParam param);

    /**
     * 分页查询手机号
     * @param param 分页查询参数
     * @return 手机号集合
     */
    List<LotteryCompanySpecifySimpleDto> selectSimplePage(LiveLotteryCompanySpecifySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveLotteryCompanySpecifySearchParam param);

    /**
     * 查询在指定中奖名单里的授权手机号
     * @param liveId 直播ID
     * @param authPhoneList 手机号集合
     * @return 在数据库表中的手机号集合
     */
    List<String> selectByAuthPhoneList(Long liveId, List<String> authPhoneList);

    /**
     * 批量查询最后一个任务ID
     * @param liveId 直播ID
     * @return key：抽奖配置ID，value：任务ID
     */
    Map<Long, Long> batchSelectLastTaskId(Long liveId);
}
