package cn.com.duiba.live.clue.service.api.param.mall.order;

import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallOrderSearch4MngParam extends PageQuery {
    private static final long serialVersionUID = -71912086722487414L;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 业务类型
     */
    private Integer bizType;

    /**
     * 订单状态
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderStatusEnum}
     */
    private Integer orderStatus;

    /**
     * 订单状态集合
     */
    private List<Integer> orderStatusList;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 下单开始时间
     */
    private Date startOrderTime;

    /**
     * 下单结束时间
     */
    private Date endOrderTime;
}
