package cn.com.duiba.live.clue.service.api.remoteservice.mall.stock.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.stock.MallStockDto;
import cn.com.duiba.live.clue.service.api.param.mall.stock.MallDeductionStockParam;

import java.util.List;
import java.util.Map;

/**
 * 商城-库存
 *
 * @author ZhangJun
 * @date 2022/7/28 11:02
 */
@AdvancedFeignClient
public interface RemoteMallStockService {

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return 库存信息
     */
    MallStockDto selectById(Long id);

    /**
     * 根据id查询
     *
     * @param ids 主键id
     * @return 库存信息
     */
    List<MallStockDto> listByIds(List<Long> ids);

    /**
     * 更新库存信息
     *
     * @param mallStockDto 库存信息
     * @return 更新结果
     */
    boolean update(MallStockDto mallStockDto);

    /**
     * 批量更新库存信息
     *
     * @param dtos 库存信息
     * @return 更新结果
     */
    boolean batchUpdate(List<MallStockDto> dtos);

    /**
     * 新增库存信息
     *
     * @param mallStockDto 库存信息
     * @return 新增结果
     */
    Long insert(MallStockDto mallStockDto);

    /**
     * 批量插入
     *
     * @param dtos 库存信息
     * @return 新增结果
     */
    List<Long> batchInsert(List<MallStockDto> dtos);

    /**
     * 物理删除
     *
     * @param id 主键id
     * @return 删除结果
     */
    boolean delete(Long id);

    /**
     * 批量物理删除
     *
     * @param ids 主键id集合
     * @return 删除结果
     */
    boolean batchDelete(List<Long> ids);

    /**
     * 扣减库存
     *
     * @param stockParamList 库存列表
     * @return 修改结果
     */
    boolean batchDeductionsStock(List<MallDeductionStockParam> stockParamList) throws BizException;

    /**
     * 新增库存
     *
     * @param id    主键id
     * @param delta 新增库存数
     * @return 执行结果
     */
    Integer incrStock(Long id, Integer delta);

    /**
     * 批量新增库存
     *
     * @param id2stockMap key: id value: 新增库存数
     * @return 执行结果
     */
    Integer batchIncrStock(Map<Long, Integer> id2stockMap);
}
