package cn.com.duiba.live.clue.service.api.dto.invitation;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播代理人邀请关系
 * @author kjj mybatis generator
 * @date 2020-03-28
 */
@Data
public class LiveAgentInvitationDto implements Serializable {

    private static final long serialVersionUID = 15853608937853393L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 直播公司下团队ID
     */
    private Long teamId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 直播是否结束：0-未结束，1-已结束
     */
    @Deprecated
    private Integer liveEnd;

    /**
     * 是否到场：0-未到场，1-已到场
     */
    private Integer present;

    /**
     * 是否直接邀请
     * 1： 自己邀请的 0：访客二度人脉扩展的
     */
    private Integer directly;

    /**
     * 渠道（推广小程序码的渠道埋点）
     */
    private String channelId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 邀请来源
     * @see cn.com.duiba.live.clue.service.api.enums.invitation.InviteSourceEnum
     */
    private Integer inviteSource;

    /**
     * 直播间状态
     */
    private Integer liveStatus;

    /**
     * 分享类型
     * @see cn.com.duiba.live.normal.service.api.enums.help.LiveHelpShareTypeEnum
     */
    private Integer shareType;
}
