package cn.com.duiba.live.clue.service.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 商城订单状态枚举
 *
 * @author xuzhigang
 * @date 2022/8/9 10:35 上午
 **/
@Getter
@AllArgsConstructor
public enum MallOrderStatusEnum {

    INIT(1, "订单初始化"),

    ORDER_FAIL(2, "下单失败"),

    WAIT_PAY(3, "待支付"),

    CANCEL_PAY(4, "取消支付"),

    TIME_OUT_CANCEL_PAY(5, "超时取消支付"),

    PAY_FAIL(6, "支付失败"),

    DELIVERY_WAIT_AUDIT(7, "发货待审核"),

    DELIVERY_AUDIT_FAIL(8, "发货审核失败"),

    WAIT_DELIVERY(9, "待发货"),

    WAIT_RECEIPT(10, "待收货"),

    CONFIRM_RECEIPT(11, "确认收货/订单已完成"),

    FINISH_AFTER_SALE(12, "售后完成"),

    /**
     * 13, 14属于直播活动订单状态
     */
    WAIT_PLACE_ORDER(13, "待下单"),

    TIMEOUT_CANCEL_ORDER(14, "超时取消订单"),
    ;

    private final Integer code;

    private final String desc;

    /**
     * 可以进行退款操作的状态集合
     */
    public static final List<Integer> CAN_REFUND_STATUS_LIST = Arrays.asList(
            DELIVERY_WAIT_AUDIT.getCode(),
            DELIVERY_AUDIT_FAIL.getCode(),
            WAIT_DELIVERY.getCode(),
            WAIT_RECEIPT.getCode(),
            CONFIRM_RECEIPT.getCode()
    );

    public static MallOrderStatusEnum getByCode(Integer code){
        for (MallOrderStatusEnum value : MallOrderStatusEnum.values()) {
            if (Objects.equals(code,value.getCode())){
                return value;
            }
        }
        return null;
    }
}
