package cn.com.duiba.live.clue.service.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallRefundOrderDto;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/08/15 17:46
 * @description 商城 - 退款 RPC
 */
@AdvancedFeignClient
public interface RemoteMallRefundOrderApiService {

    /**
     * 新增
     *
     * @param dto 记录
     * @return 新增结果
     */
    int insert(MallRefundOrderDto dto);

    /**
     * 根据订单Id查询退款记录
     *
     * @param orderId 订单Id
     * @return 退款记录列表
     */
    List<MallRefundOrderDto> findByOrderId(Long orderId);

    /**
     * 根据退款单号查询退款记录
     *
     * @param bizRefundNo 退款单号
     * @return 退款记录
     */
    MallRefundOrderDto findByBizRefundNo(String bizRefundNo);

    /**
     * 更新退款状态
     *
     * @param bizRefundNo 退款单号
     * @param status      退款状态
     * @param oldStatus   旧的退款状态
     * @return 更新结果
     */
    int updateStatusByBizRefundNo(String bizRefundNo, Integer status, Integer oldStatus);

    /**
     * 更新退款成功收单状态
     *
     * @param bizRefundNos 退款单号
     * @return 更新结果
     */
    int updateSuccessAcceptStatusByBizRefundNos(List<String> bizRefundNos);

    /**
     * 退款成功 更新成功状态以及退款成功时间
     *
     * @param bizRefundNo 退款单号
     * @param refundTime  退款时间
     * @return 更新结果
     */
    int updateSuccessStatusByBizRefundNo(String bizRefundNo, Date refundTime);

    /**
     * 退款失败 更新失败状态
     *
     * @param bizRefundNo 退款单号
     * @return 更新结果
     */
    int updateFailStatusByBizRefundNo(String bizRefundNo);

}
