package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订单商品快照
 *
 * @author xuzhigang
 * @date 2022/8/16 10:39 下午
 **/
@Data
public class MallOrderGoodsSnapDto implements Serializable {
    private static final long serialVersionUID = 8125872912766028876L;

    /**
     * 商品配置id
     */
    private Long confId;

    /**
     * 商品库商品id
     */
    private Long goodsId;

    /**
     * 商品id
     */
    private Long spuId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 商品类型 1-实物 2-虚拟
     */
    private Integer goodsType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品图片
     */
    private String goodsImg;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 售价
     */
    private Integer discountedPrice;

    /**
     * 商品规格
     */
    private String goodsAttribute;

    /**
     * 商品限制区域
     */
    private String limitRegionName;

    /**
     * 购买数量限制
     */
    private Integer maxBuyNum;

    /**
     * 支持的支付方式
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.PayChannelEnum}
     */
    private List<Integer> payChannels;

    /**
     * 限制银行编码
     */
    private List<String> restrictedBankCodes;
}
