package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 订单列表相关订单信息
 * 要啥字段加啥字段，不需要订单表的全部字段，不然太多了
 *
 * @author xuzhigang
 * @date 2022/8/17 10:55 上午
 **/
@Data
public class MallOrderListDto implements Serializable {
    private static final long serialVersionUID = 7971945034176931698L;

    /**
     * 订单id
     */
    private Long id;

    /**
     * 订单编号
     */
    private String bizOrderNo;

    /**
     * 支付渠道
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.PayChannelEnum}
     */
    private Integer payChannel;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单价格
     */
    private Integer orderAmount;

    /**
     * 购买数量
     */
    private Integer buyNum;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 预支付id
     */
    private String prepayId;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 银联趣分期 二维码链接
     */
    private String qrNo;

    /**
     * 商品信息
     */
    private MallOrderGoodsSnapDto goodsInfo;

    /**
     * 收货地址信息
     */
    private MallOrderAddressInfoDto addressInfo;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
