package cn.com.duiba.live.clue.service.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallOrderNegotiationDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/08/11 10:44
 * @description 商城 - 协商记录 RPC
 */
@AdvancedFeignClient
public interface RemoteMallOrderNegotiationService {

    /**
     * 新增
     *
     * @param dto 协商记录
     * @return 执行结果
     */
    int insert(MallOrderNegotiationDto dto);

    /**
     * 根据订单记录查询
     *
     * @param orderId 订单Id
     * @return 协商记录集合
     */
    List<MallOrderNegotiationDto> listByOrderId(Long orderId);

}