package cn.com.duiba.live.clue.service.api.remoteservice.third.bank.cardhold;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.third.bank.cardhold.LiveCardHolderDto;

import java.util.List;

/**
 * @author ouyang
 * @date 2022/8/17 11:28 上午
 */
@AdvancedFeignClient
public interface RemoteLiveCardHolderService {

    /**
     * 批量新增或更新
     * @param holderList 持卡信息集合
     * @return 执行结果
     */
    int batchSaveOrUpdate(List<LiveCardHolderDto> holderList);

    /**
     * 根据直播用户和持卡类型查询持卡状态(走redis缓存)
     * @param liveUserId 直播用户ID
     * @param cardHolderType 持卡类型
     * @see cn.com.duiba.live.clue.service.api.enums.third.bank.cardhold.CardHolderTypeEnum
     * @return 用户持卡状态
     */
    LiveCardHolderDto getByLiveUserIdAndTypeCache(Long liveUserId, Integer cardHolderType);

    /**
     * 批量查询用户持卡信息
     * @param liveUserIds 直播用户ID
     * @return 持卡信息集合
     */
    List<LiveCardHolderDto> batchGetByLiveUserIdsAndTypes(List<Long> liveUserIds);

}
