package cn.com.duiba.live.clue.service.api.dto.clue;

import cn.com.duiba.live.clue.service.api.enums.clue.LivePassAnswerResultEnum;
import cn.com.duiba.live.clue.service.api.enums.clue.LivePassAnswerTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 直播线索-选择题
 * @author kjj mybatis generator 
 * @date 2020-05-18
 */
@Data
public class LivePassAnswerRecordDto implements Serializable {

    private static final long serialVersionUID = 6089881414608973575L;
    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveUserId;

    /**
     * 答题结果，0:错误,1:正确
     * @see LivePassAnswerResultEnum
     */
    private Integer answerResult;

    /**
     * 答题类型,1:正常答题,2:补答,3:复活
     * @see LivePassAnswerTypeEnum
     */
    private Integer answerType;

    /**
     * 题目选项ID
     */
    private Long optionId;

    /**
     * 问题ID
     */
    private Long quesId;
}