package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class MallOrderListMngDto implements Serializable {

    private static final long serialVersionUID = 4866734264605125466L;
    /**
     * 订单id
     */
    private Long id;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 业务类型
     */
    private Integer bizType;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单价格
     */
    private Integer orderAmount;

    /**
     * 购买数量
     */
    private Integer buyNum;

    /**
     * 小程序appId
     */
    private String appId;

    /**
     * 预支付id
     */
    private String prepayId;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 商品信息
     */
    private MallOrderGoodsSnapDto goodsInfo;

    /**
     * 收货地址信息
     */
    private MallOrderAddressInfoDto addressInfo;

    /**
     * 优惠券信息
     */
    private List<MallOrderCouponSnapDto> couponSnap;

    /**
     * 订单编号
     * max length = 64
     */
    private String bizOrderNo;
    /**
     * 是否有售后 0-无 1-有
     */
    private Integer afterSale;

    /**
     * 售卖规格库存单元id，tb_mall_sku.id
     */
    private Long skuId;

    /**
     * 售卖商品id，tb_mall_spu.id
     */
    private Long spuId;

    /**
     * 支付时间
     */
    private Date paidTime;

    /**
     * 买家留言
     */
    private String buyerMsg;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 支付渠道1-微信支付
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.PayChannelEnum}
     */
    private Integer payChannel;

    /**
     * 物流单号
     */
    private String expressNum;

    /**
     * 物流公司
     */
    private String expressCompany;

    /**
     * 银行编码
     */
    private String bankCode;

    /**
     * 银行卡号
     */
    private String bankCardNo;

    /**
     * 虚拟商品发货详情
     */
    private MallOrderVirtualExchangeInfoDto virtualExchangeInfo;

    /**
     * 进入待发货时间
     */
    private Date preDeliveryTime;
}
