package cn.com.duiba.live.clue.service.api.dto.voucher;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户代金券表
 *
 * @author kjj mybatis generator
 * 2022-01-25
 */
@Data
public class LiveUserVoucherDto implements Serializable {
    private static final long serialVersionUID = 1643077736926827L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代金券ID
     */
    private Long voucherId;

    /**
     * 获得券的代理人ID。
     */
    private Long agentId;

    /**
     * 券所属用户的userID. 0:未赠送，不属于任何用户
     */
    private Long userId;

    /**
     * 1:未赠送 2: 转赠中 3:正常 4:已使用
     * {@link cn.com.duiba.live.clue.service.api.enums.voucher.VoucherStateEnum}
     */
    private Integer voucherState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
