package cn.com.duiba.live.clue.service.api.enums.mall.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/12/14 17:38
 * @description 商城 - 虚拟商品兑换类型
 */
@Getter
@AllArgsConstructor
public enum VirtualExchangeTypeEnum {

    CODE(1, "兑换码"),
    LINK(2, "兑换链接"),
    CARD_NO(3, "卡号卡密"),

    ;
    private final Integer type;
    private final String desc;

    private static final Map<Integer, VirtualExchangeTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    VirtualExchangeTypeEnum::getType,
                    Function.identity(),
                    (v1, v2) -> v2
            ))
    );

    public static VirtualExchangeTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

}
