package cn.com.duiba.live.clue.service.api.enums.mall.order;

import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.Set;

/**
 * 商城订单业务枚举
 *
 * @author ouyang
 * @date 2022/10/21 10:35 上午
 **/
@Getter
@AllArgsConstructor
public enum MallOrderBizTypeEnum {

    LIVE(1, "直播场景"),
    BANK_APPLY_ACTIVITY(2, "银行办卡活动场景"),
    LIVE_ACTIVITY(3, "直播活动"),
    ;

    private final Integer code;

    private final String desc;

    private static final Set<Integer> LIVE_TYPES = Collections.unmodifiableSet(
            Sets.newHashSet(LIVE.getCode(), LIVE_ACTIVITY.getCode())
    );

    /**
     * 是否是直播类型订单
     * @param type 类型
     * @return true-是，false-不是
     */
    public static boolean isLiveOrder(Integer type) {
        if (type == null) {
            return false;
        }
        return LIVE_TYPES.contains(type);
    }
}
