package cn.com.duiba.live.clue.service.api.param.mall.order;

import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallOrderSearch4MngParam extends PageQuery {
    private static final long serialVersionUID = -71912086722487414L;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 业务类型
     */
    private Integer bizType;

    /**
     * 订单状态
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderStatusEnum}
     */
    private Integer orderStatus;

    /**
     * 订单状态集合
     */
    private List<Integer> orderStatusList;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * ids
     */
    private List<Long> ids;

    /**
     * 下单开始时间
     */
    private Date startOrderTime;

    /**
     * 下单结束时间
     */
    private Date endOrderTime;


    /**
     * mall_goods.id
     */
    private Long goodsId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 收货人姓名
     */
    private String receiverName;

    /**
     * 收货人手机号
     */
    private String receiverPhoneNum;


    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 是否需要过滤正在售后中的订单
     * true-需要过滤 false-不需要过滤
     */
    private boolean needFilterAfterSale;

    /**
     * 进入发货开始时间
     */
    private Date preDeliveryStartTime;

    /**
     * 进入发货结束时间
     */
    private Date preDeliveryEndTime;
}
