package cn.com.duiba.live.clue.service.api.remoteservice.mall.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.coupon.user.MallUserCouponDto;
import cn.com.duiba.live.clue.service.api.dto.mall.coupon.user.MallUserUsingCouponDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMallUserCouponServiceApi {
    /**
     * 查询优惠券发放数量
     * @param couponId 优惠券ID
     * @return 优惠券发放数量
     */
    Long selectCouponCount(Long couponId);

    /**
     * 使用优惠券
     * @param couponId 优惠券ID
     * @param liveUserId 用户ID
     */
    void usedCoupon(MallUserUsingCouponDto dto);

    /**
     * 回滚一张优惠券
     * @param couponId 优惠券ID
     * @param liveUserId 用户ID
     */
    void rollbackUserCoupon(MallUserUsingCouponDto dto);

    /**
     * 批量发放优惠券
     * @param list 优惠券列表
     */
    void batchInsert(List<MallUserCouponDto> list);

}
