package cn.com.duiba.live.normal.service.api.dto.link;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播推广链接表
 * @author kjj mybatis generator 
 * @date 2020-08-05
 */
@Data
public class LiveSpreadLinkDto implements Serializable {
     
    private static final long serialVersionUID = 1596617127178305L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 公司ID，对应tb_live_company.id
     */
    private Long companyId;

    /**
     * 直播ID，对应tb_live.id
     */
    private Long liveId;

    /**
     * 小程序地址地址
     */
    private String mpQrCode;

    /**
     * 渠道备注
     */
    private String channelRemark;

    /**
     * 跳转链接
     */
    private String linkUrl;

    /**
     * 链接类型 1：公司 2：直播
     * @see cn.com.duiba.live.normal.service.api.enums.live.LiveSpreadLinkTypeEnum
     */
    private Integer linkType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}