package cn.com.duiba.live.normal.service.api.enums.importtask;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 导入任务类型枚举
 *
 * @author xuzhigang
 * @date 2020/10/21 1:59 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveImportTaskTypeEnum {
    UPLOAD_ACTIVATE_AGENT(1, "上传架构名单"),

    DELETE_ACTIVATE_AGENT(2, "删除架构名单"),

    BATCH_DELETE_PERMISSION(3, "业务员列表-批量删除权限"),

    BATCH_CHANGE_TEAM(4, "业务员列表-批量切换团队"),

    BATCH_UPDATE_AGENT(5, "业务员列表-批量更新信息"),

    LOTTERY_SPECIFY(6, "抽奖-中奖名单"),

    UPLOAD_ACTIVATE_AGENT_CUSTOM(7, "上传架构名单定制"),

    DELETE_ACTIVATE_AGENT_CUSTOM(8, "删除架构名单定制"),

    BATCH_DELETE_PERMISSION_CUSTOM(9, "业务员列表-批量删除权限定制"),

    BATCH_CHANGE_TEAM_CUSTOM(10, "业务员列表-批量切换团队定制"),

    BATCH_UPDATE_AGENT_CUSTOM(11, "业务员列表-批量更新信息定制"),
    ;

    /**
     * 导入任务类型
     */
    private final Integer taskType;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveImportTaskTypeEnum> MAP = new HashMap<>();

    static {
        Arrays.stream(values()).forEach(type -> MAP.put(type.getTaskType(), type));
    }

    /**
     * 根据type获取枚举
     */
    public static LiveImportTaskTypeEnum getEnumByType(Integer type) {
        return MAP.get(type);
    }
}
