package cn.com.duiba.live.normal.service.api.remoteservice.activate;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.activate.ActivateImportDataDto;
import cn.com.duiba.live.normal.service.api.dto.activate.ActivateImportFailureDataDto;
import cn.com.duiba.live.normal.service.api.dto.activate.ActivateImportId2PhoneDto;
import cn.com.duiba.live.normal.service.api.param.activate.ActivateImportDataSearchParam;

import java.util.List;

/**
 * 直播账号激活，导入数据
 *
 * @author lizhi
 * @date 2020/7/20 4:00 PM
 */
@AdvancedFeignClient
public interface RemoteActivateImportDataApiService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播账号激活导入数据集合
     */
    List<ActivateImportDataDto> selectList(ActivateImportDataSearchParam param);

    /**
     * 根据手机号查询导入数据
     *
     * @param phoneNumber 手机号
     * @return 导入数据
     */
    ActivateImportDataDto selectByPhoneNumber(String phoneNumber);

    /**
     * 根据条件查询主键，分页
     *
     * @param param 分页查询条件
     * @return 主键集合
     */
    List<Long> selectIdPage(ActivateImportDataSearchParam param);

    /**
     * 批量新增
     *
     * @param list 直播账号激活导入数据
     * @return 执行结果
     */
    int batchInsert(List<ActivateImportDataDto> list);

    /**
     * 批量物理删除
     *
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 批量插入失败数据
     *
     * @param failureList
     * @return
     */
    int batchInsertFailureData(List<ActivateImportFailureDataDto> failureList);

    /**
     * 根据导入任务id 获取失败列表
     * 瀑布流查询
     *
     * @return
     */
    List<ActivateImportFailureDataDto> getFailureListByTaskId(Long taskId, Long lastMaxId, Integer pageSize);

    /**
     * 根据taskId 统计总数
     *
     * @param taskId
     * @return
     */
    long countFailureByTaskId(Long taskId);

    /**
     * 根据手机列表查询详情
     *
     * @param phoneList
     * @return
     */
    List<ActivateImportDataDto> findByPhoneList(List<String> phoneList);

    /**
     * 根据手机号码查询主键
     *
     * @param phoneList
     * @return
     */
    List<ActivateImportId2PhoneDto> findIdsByPhoneList(List<String> phoneList);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(ActivateImportDataSearchParam param);

    /**
     * 根据条件查询，分页
     *
     * @param param 查询条件
     * @return 直播账号激活导入数据集合
     */
    List<ActivateImportDataDto> selectPage(ActivateImportDataSearchParam param);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return true-删除成功 false-删除失败
     */
    boolean delete(Long id);

    /**
     * 根据手机号批量删除
     *
     * @param phoneNumbers 手机号
     * @param companyId    公司id
     * @return 执行结果
     */
    int batchDeleteByPhoneNumbers(List<String> phoneNumbers, Long companyId);

    /**
     * 根据公司id查询手机号
     *
     * @param companyId 公司id
     * @return 手机号集合
     */
    List<String> findPhoneNumbersByCompanyId(Long companyId);

    /**
     * 批量更新
     *
     * @param list 架构名单
     * @return 执行结果
     */
    int batchUpdate(List<ActivateImportDataDto> list);

    /**
     * 根据工号和公司id查询
     *
     * @param companyId 公司id
     * @param jobNumber 工号
     * @return 架构名单信息
     */
    @Deprecated
    ActivateImportDataDto findByCompanyIdAndJobNumber(Long companyId, String jobNumber);

    /**
     * 根据工号和公司id查询
     * @param jobNumber 用户输入的工号
     * @param defaultJobNumber 公司默认激活工号
     * @param companyId 公司id
     * @return 架构名单信息
     */
    ActivateImportDataDto findByJobNumberAndCompanyId(String jobNumber,String defaultJobNumber,Long companyId);

    /**
     * 根据公司id查询工号
     *
     * @param companyId 公司id
     * @return 工号集合
     */
    List<String> findJobNumbersByCompanyId(Long companyId);

    /**
     * 根据工号和公司id删除架构名单
     *
     * @param jobNumbers 工号
     * @param companyId  公司id
     * @return 执行结果
     */
    int batchDeleteByJobNumbers(List<String> jobNumbers, Long companyId);

    /**
     * 根据工号和公司id查询
     *
     * @param companyId 公司id
     * @param phoneNumber 手机号
     * @return 架构名单信息
     */
    ActivateImportDataDto findByCompanyIdAndPhoneNumber(Long companyId, String phoneNumber);

    /**
     * 新增
     * @param dto 直播账号激活导入数据
     * @return 执行结果
     */
    int saveOrUpdateByCompanyIdAndJobNumber(ActivateImportDataDto dto);
}
