package cn.com.duiba.live.normal.service.api.remoteservice.successagent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.successagent.LiveSuccessAgentVerifyRecordDto;
import cn.com.duiba.live.normal.service.api.param.successagent.LiveSuccessAgentVerifyRecordSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2021-01-30 10:38
 * @descript 成功案例打款审核remoteService
 */
@AdvancedFeignClient
public interface RemoteLiveSuccessAgentVerifyRecordService {

    /**
     * 根据入参查询列表
     * @param param
     * @return
     */
    List<LiveSuccessAgentVerifyRecordDto> findByParam(LiveSuccessAgentVerifyRecordSearchParam param);

    /**
     * 根据入参查询总数
     * @param param
     * @return
     */
    long countByParam(LiveSuccessAgentVerifyRecordSearchParam param);

    /**
     * 新增记录
     * @param dto
     * @return
     */
    long add(LiveSuccessAgentVerifyRecordDto dto);

    /**
     * 根据主键更新
     * @param dto
     * @return
     */
    int updateById(LiveSuccessAgentVerifyRecordDto dto);

    /**
     * 根据直播ids查询通过审批的总数map
     * @param liveIds
     * @return
     */
    Map<Long, Long> groupCountPassNumByLiveIds(List<Long> liveIds);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    LiveSuccessAgentVerifyRecordDto findById(Long id);

    /**
     * 根据直播id、代理人id和审核状态查询记录
     * @param liveId
     * @param agentId
     * @param verifyStates
     * @return
     */
    List<LiveSuccessAgentVerifyRecordDto> findByLiveAgentIdAndState(Long liveId, Long agentId, List<Integer> verifyStates);

    /**
     * 根据参数查询金额
     * @param param
     * @return
     */
    long sumAmountByParam(LiveSuccessAgentVerifyRecordSearchParam param);
}
