package cn.com.duiba.live.normal.service.api.enums.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 小程序卡片跳转链接类型
 *
 * @author xuzhigang
 * @date 2021/3/1 4:43 下午
 **/
@Getter
@AllArgsConstructor
public enum LivePushCardPathTypeEnum {
    CLUE_PAGE(1, "pages/index/index?s=24&liveId=%s&companyId=%s&accessSource=107012", "客户线索列表页"),

    PRIZE_LIST_PAGE(2, "/pages/index/index?s=31&liveId=%s&companyId=%s&accessSource=107012", "中奖名单页"),

    OTHER_PAGE(99, "", "其他"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 跳转链接
     */
    private final String path;

    /**
     * 描述
     */
    private final String desc;
}
