package cn.com.duiba.live.normal.service.api.remoteservice.chinalife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.chinalife.ChinaLifeUserRelatedDto;

/**
 * 中国人寿用户关联
 * @author 吴文哲
 * @date 2021/3/16 5:53 下午
 **/
@AdvancedFeignClient
public interface RemoteChinaLifeUserRelatedApiService {

    /**
     * 根据直播间Id + 中国人寿直播用户id 查询对应关系表
     * @param liveId 直播间id
     * @param liveUserId 中国人寿直播用户id
     * @return 中国人寿用户关联记录
     */
    ChinaLifeUserRelatedDto findByLiveIdAndLiveUserId(Long liveId, Long liveUserId);
}
