package cn.com.duiba.live.normal.service.api.remoteservice.importtask;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.importtask.LiveImportTaskDto;
import cn.com.duiba.live.normal.service.api.param.importtask.LiveImportTaskSearchParam;

import java.util.List;

/**
 * 导入任务相关服务
 *
 * @author xuizhigang
 * @date 2020-10-21
 */
@AdvancedFeignClient
public interface RemoteLiveImportTaskApiService {
     
    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 导入任务集合
     */
    List<LiveImportTaskDto> selectListPage(LiveImportTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveImportTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 导入任务
     */
    LiveImportTaskDto selectById(Long id);

    /**
     * 根据主键查询
     * @param idList 主键集合
     * @return 导入任务
     */
    List<LiveImportTaskDto> selectByIds(List<Long> idList);

    /**
     * 新增
     * @param dto 导入任务
     * @return 执行结果
     */
    int insert(LiveImportTaskDto dto);

    /**
     * 新增 返回主键
     *
     * @param dto 导入任务
     * @return 主键
     */
    Long insertAndGetId(LiveImportTaskDto dto);

    /**
     * 更新
     * @param dto 导入任务
     * @return 执行结果
     */
    int update(LiveImportTaskDto dto);

    /**
     * 更新任务状态
     *
     * @param id 主键id
     * @param taskStatus 任务状态 {@link cn.com.duiba.live.normal.service.api.enums.importtask.LiveImportTaskStatusEnum}
     * @return 执行结果
     */
    int updateTaskStatus(Long id, Integer taskStatus);
}