package cn.com.duiba.live.normal.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.company.LiveCompanyTeamDto;
import cn.com.duiba.live.normal.service.api.dto.company.LiveCompanyTeamNameDto;
import cn.com.duiba.live.normal.service.api.param.company.LiveCompanyTeamSearchParam;
import cn.com.duiba.live.normal.service.api.param.company.LiveCompanyTeamWaterFallParam;

import java.util.List;
import java.util.Map;

/**
 * Created with duiba.
 * User: zhouzhou
 * Date: 2020/3/28 0028 Time: 10:31
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyTeamApiService {


    /**
     * 保存更新直播公司团队
     * @param dto 直播公司团队
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveCompanyTeamDto dto);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司团队
     */
    LiveCompanyTeamDto findById(Long id);

    /**
     * 根据id物理删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Integer deleteById(Long id);

    /**
     * 根据id逻辑删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Integer logicDeleteById(Long id);

    /**
     * 根据id批量查询
     * @param ids
     * @return
     */
    List<LiveCompanyTeamDto> findByIds(List<Long> ids);

    /**
     * 查询团队名称
     * @param ids 团队主键集合
     * @return key：团队主键，value：团队名称
     */
    Map<Long, String> findTeamNameMap(List<Long> ids);

    /**
     * 根据条件查询列表
     * @param searchParam
     * @return
     */
    List<LiveCompanyTeamDto> findByCondition(LiveCompanyTeamSearchParam searchParam);

    /**
     * 根据条件统计
     * @param searchParam
     * @return
     */
    Integer countByCondition(LiveCompanyTeamSearchParam searchParam);

    /**
     * 根据公司id 查询团队列表
     * @param companyId
     * @return
     */
    List<LiveCompanyTeamDto> findByCompanyId(Long companyId);

    /**
     * todo 瀑布流
     * 分页查询
     *
     * @param startId 开始id
     * @param pageSize 每页大小
     * @return 公司团队集合
     */
    List<LiveCompanyTeamDto> findByStartIdAndPageSize(Long startId, Integer pageSize);

    /**
     * 批量插入团队信息
     *
     * @param dtoList 团队信息集合
     * @return 执行结果
     */
    int batchInsert(List<LiveCompanyTeamDto> dtoList);

    /**
     * 批量插入并返回团队信息
     *
     * @param dtoList 团心信息集合
     * @return 团队信息集合
     */
    List<LiveCompanyTeamNameDto> batchInsertAndGet(List<LiveCompanyTeamDto> dtoList);

    /**
     * 根据主键批量更新团队预期人数
     * @param updateList 待更新列表
     * @return 影响行数
     */
    int batchUpdateExpectedNumById(List<LiveCompanyTeamDto> updateList);

    /**
     * todo 瀑布流
     * 瀑布流查询公司下的所有团队
     * @param param 查询参数
     * @return 公司团队列表
     */
    List<LiveCompanyTeamDto> findWithWaterFall(LiveCompanyTeamWaterFallParam param);

    /**
     * 根据公司id和团队名称查询团队id 如果团队不存在 新建团队并返回
     *
     * @param companyId 公司id
     * @param teamName 团队名称
     * @return 团队id
     */
    Long findOrSaveByTeamName(Long companyId, String teamName);

    /**
     * 根据公司id查询定制的团队id "尚未选择团队" 该团队不显示在团队榜
     *
     * @param companyId 工地id
     * @return 团队id
     */
    Long findCustomTeamIdWithCache(Long companyId);

    /**
     * 更新团队标志
     *
     * @param id 主键
     * @param teamFlag 团队标识 {@link cn.com.duiba.live.normal.service.api.enums.team.TeamFlagEnum}
     * @return 更新结果
     */
    int updateTeamFlag(Long id, Integer teamFlag);

    /**
     * 根据公司id和团队标识查询团队
     *
     * @param companyId 公司id
     * @param teamFlag 团队标识 {@link cn.com.duiba.live.normal.service.api.enums.team.TeamFlagEnum}
     * @return 团队id集合
     */
    List<Long> selectIdsByCompanyIdAndTeamFlag(Long companyId, Integer teamFlag);

    /**
     * 根据id批量查询 !!! 忽略删除状态 !!!
     * @param ids 团队id列表
     * @return 团队列表
     */
    List<LiveCompanyTeamDto> findByIdsIgnoreDeletedStatus(List<Long> ids);

}
