package cn.com.duiba.live.normal.service.api.remoteservice.pub.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.pub.form.PubFormRecordDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试记录 RPC 接口
 */
@AdvancedFeignClient
public interface RemotePubFormRecordApiService {

    /**
     * 插入记录
     *
     * @param dto 测试记录
     * @return 记录主键
     */
    Long insert(PubFormRecordDto dto);

    /**
     * 更新验证状态
     *
     * @param recordId 主键
     * @return 执行结果
     */
    int updateAuthStatus(Long recordId);

    /**
     * 查询提交记录
     *
     * @param recordId 主键
     * @return 提交记录
     */
    PubFormRecordDto findById(Long recordId);

    /**
     * 根据表单ID和手机号批量查询处URL_Link
     * 用于数据上报
     * @param formId 表单ID
     * @param phoneNums 手机号列表
     * @return UrlLinkList
     */
    List<String> batchSelectUrlLinkByFormIdAndPhone(Long formId, List<String> phoneNums);

    /**
     * 批量插入记录
     *
     * @param list 测试记录列表
     * @return 主键
     */
    List<Long> batchInsert(List<PubFormRecordDto> list);

    /**
     * 通过id批量修改验证状态
     *
     * @param list 主键集合
     * @return 执行结果
     */
    int batchUpdateAuthStatus(List<Long> list);

    /**
     * 查询提交记录 一次查询100条 - 管理后台专用
     *
     * @param formId  表单Id
     * @param startId 开始查询Id
     * @return 记录列表
     */
    List<PubFormRecordDto> listByFormId(Long formId, Long startId);

    /**
     * 查询提交记录
     *
     * @param recordIds 提交记录Id
     * @return 记录列表
     */
    List<PubFormRecordDto> listByIds(List<Long> recordIds);

}
