package cn.com.duiba.live.normal.service.api.enums.pub.form;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.map.HashedMap;

import java.util.Map;
import java.util.Objects;

/**
 * 回传状态枚举
 * @author xiaocong
 * @date 2021/11/3 11:17 上午
 */
@Getter
@AllArgsConstructor
public enum RecordCallbackStatusEnum {

    /**
     * 未回传
     */
    UNFINISHED(0,"未回传"),

    /**
     * 已回传
     */
    FINISHED(1,"已回传");

    /**
     * 回传状态状态码
     */
    private final Integer code;

    /**
     * 回传状态描述
     */
    private final String description;

    private static final Map<Integer, RecordCallbackStatusEnum> STATUS_MAP = new HashedMap<>();

    static {
        for (RecordCallbackStatusEnum recordCallbackStatusEnum : values()) {
            STATUS_MAP.put(recordCallbackStatusEnum.code, recordCallbackStatusEnum);
        }
    }

    /**
     * 通过code获得枚举
     * @param code
     * @return
     */
    public static RecordCallbackStatusEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return UNFINISHED;
        }
        return STATUS_MAP.get(code);
    }
}
