package cn.com.duiba.live.normal.service.api.enums.pub.form;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.map.HashedMap;

import java.util.Map;
import java.util.Objects;

/**
 * 回传记录表标签枚举
 *
 * @author xiaocong
 * @date 2021/11/3 11:08 上午
 */

@Getter
@AllArgsConstructor
public enum RecordLabelEnum {


    /**
     * 其他
     */
    OTHER(-1, "其他"),

    /**
     * 暂无
     */
    NOT(0, "暂无"),

    /**
     * 有效
     */
    VALID(1, "有效"),

    /**
     * 无效
     */
    INVALID(2, "无效的");

    /**
     * 标签状态码
     */
    private final Integer code;

    /**
     * 标签描述
     */
    private final String description;

    private static final Map<Integer, RecordLabelEnum> LABEL_MAP = new HashedMap<>();

    static {
        for (RecordLabelEnum recordLabelEnum : values()) {
            LABEL_MAP.put(recordLabelEnum.code, recordLabelEnum);
        }
    }

    /**
     * 通过code获得枚举
     * @param code
     * @return
     */
    public static RecordLabelEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return INVALID;
        }
        return LABEL_MAP.get(code);
    }
}
