package cn.com.duiba.live.normal.service.api.enums.oto.cust.follow;

import cn.com.duiba.live.normal.service.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-25 09:54
 * 跟进权重枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustFollowWeightEnum {

    A(1, "A"),
    B(2, "B"),
    C(3, "C"),
    ;

    /**
     * 通知类型
     */
    private final Integer type;

    /**
     * 备注
     */
    private final String desc;

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustFollowWeightEnum::getType, OtoCustFollowWeightEnum::getDesc)));

    /**
     * 根据类型获取备注
     */
    public static String getDescByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return TYPE_MAP.get(type);
    }

    /**
     * 根据类型获取备注
     */
    public static boolean contains(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return TYPE_MAP.containsKey(type);
    }
}
