package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import cn.com.duiba.live.normal.service.api.util.NumberUtil;
import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 17:23
 */
@Getter
@AllArgsConstructor
public enum OtoCustValueEnum {

    X("X", 101, 1, "拨打未接通次数 >= 5"),
    N("N", 102, 2, "拨打次数5次内未接通"),
    NULL("", 0, 4, "默认为空"),
    ZERO("0", 200, 3, "销售手动输入"),
    ONE("1", 201, 5, "销售手动输入"),
    TWO("2", 202, 6, "销售手动输入"),
    @Deprecated
    THREE("3", 203, 7, "销售手动输入"),
    @Deprecated
    THREE_A("3-A", 301, 10, "递交了计划书，近期有机会成交"),
    @Deprecated
    THREE_B("3-B", 302, 9, "递交了计划书，近期无法成交"),
    @Deprecated
    THREE_C("3-C", 303, 8, "递交了计划书,拒绝");

    /**
     * 展示价值
     */
    private final String showValue;

    /**
     * 价值
     */
    private final Integer realValue;

    /**
     * 排序值
     */
    private final Integer sort;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 低级价值
     */
    public static final Set<Integer> LOWER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet(X.getRealValue(), N.getRealValue(), ZERO.getRealValue()));

    /**
     * 手动输入数字价值
     */
    public static final Set<Integer> NUMBER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet(ZERO.getRealValue(), ONE.getRealValue(), TWO.getRealValue(), THREE.getRealValue()));

    /**
     * key：realValue value：showValue
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustValueEnum::getRealValue, OtoCustValueEnum::getShowValue)));

    /**
     * key：realValue value：sort
     */
    private static final Map<Integer, Integer> SORT_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustValueEnum::getRealValue, OtoCustValueEnum::getSort)));

    public static String getShowValue(Integer realValue) {
        if (NumberUtil.isNullOrLteZero(realValue)) {
            return null;
        }
        return ALL_MAP.get(realValue);
    }

    public static Integer getSort(Integer realValue) {
        if (NumberUtil.isNullOrLteZero(realValue)) {
            return null;
        }
        return SORT_MAP.get(realValue);
    }

    /**
     * 是否可以人工替换为新的价值
     *
     * @param oldValue 老的value
     * @param newValue 新的value
     * @return 是否可以替换
     */
    public static boolean humanReplace(Integer oldValue, Integer newValue) {
        if (newValue == null) {
            return false;
        }
        // 新旧值相同，可以替换
        if (newValue.equals(oldValue)) {
            return true;
        }
        // N，0，1，2可以相互替换
        return N.getRealValue().equals(newValue) ||
                ZERO.getRealValue().equals(newValue) ||
                ONE.getRealValue().equals(newValue) ||
                TWO.getRealValue().equals(newValue);
    }
}
