package cn.com.duiba.live.normal.service.api.enums.oto.cust.follow;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author ZhangJun
 * @date 2022/2/15 18:25
 */
@Getter
@AllArgsConstructor
public enum OtoCustAssignTypeEnum {

    /**
     * ！！！ 新增此枚举时，记得数据要插入tb_seller_assign_record(销售客户分配记录表)
     */

    ADMIN_ASSIGN(1, "管理后台分配"),
    SELLER_TAKE_FRESH(2, "销售主动从投放池认领"),
    SELLER_TAKE_RECYCLE(3, "销售主动从回收池认领"),
    SYSTEM_ASSIGN(4, "系统强制分配"),
    SELF_BUILT(5, "自建客户"),
    ;

    private final Integer assignType;
    private final String desc;

    /**
     * 强制分配类型
     */
    private static final List<OtoCustAssignTypeEnum> FORCE_ASSIGN_LIST = Lists.newArrayList();

    static {
        FORCE_ASSIGN_LIST.add(ADMIN_ASSIGN);
        FORCE_ASSIGN_LIST.add(SYSTEM_ASSIGN);
    }

    public static final List<Integer> forceAssignTypes() {
        return FORCE_ASSIGN_LIST.stream().map(OtoCustAssignTypeEnum::getAssignType).collect(Collectors.toList());
    }
}
